#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:178
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24564);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2937");
 
 name["english"] = "MDKSA-2006:178: ntp";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:178 (ntp).

Openssl recently had several vulnerabilities which were patched
(CVE-2006-2937,2940,3738,4339, 4343). Some versions of ntp are built
against a static copy of the SSL libraries. As a precaution an updated
copy built against the new libraries in being made available.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:178
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ntp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ntp-4.2.0-21.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ntp-client-4.2.0-21.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ntp-4.2.0-31.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ntp-client-4.2.0-31.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"ntp-", release:"MDK2006.0")
 || rpm_exists(rpm:"ntp-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-2937", value:TRUE);
}
