#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:189
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24574);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5601", "CVE-2006-5602");
 
 name["english"] = "MDKSA-2006:189: xsupplicant";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:189 (xsupplicant).

Yannick Van Osselaer discovered a stack overflow in Xsupplicant, which
could potentially be exploited by a remote, authenticated user to gain
root priviledges. Additional code cleanups to fix potential memory
leaks are also included.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:189
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xsupplicant package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xsupplicant-1.0.1-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xsupplicant-doc-1.0.1-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xsupplicant-1.2.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xsupplicant-devel-1.2.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xsupplicant-doc-1.2.6-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"xsupplicant-", release:"MDK2006.0")
 || rpm_exists(rpm:"xsupplicant-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5601", value:TRUE);
 set_kb_item(name:"CVE-2006-5602", value:TRUE);
}
