#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:190
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24575);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5297", "CVE-2006-5298");
 
 name["english"] = "MDKSA-2006:190: mutt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:190 (mutt).

A race condition in the safe_open function in the Mutt mail client
1.5.12 and earlier, when creating temporary files in an NFS filesystem,
allows local users to overwrite arbitrary files due to limitations of
the use of the O_EXCL flag on NFS filesystems. (CVE-2006-5297)
The mutt_adv_mktemp function in the Mutt mail client 1.5.12 and earlier
does not properly verify that temporary files have been created with
restricted permissions, which might allow local users to create files
with weak permissions via a race condition between the mktemp and
safe_fopen function calls. (CVE-2006-5298)
Updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:190
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mutt-1.5.9i-9.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-utf8-1.5.9i-9.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.5.11-5.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-utf8-1.5.11-5.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"mutt-", release:"MDK2006.0")
 || rpm_exists(rpm:"mutt-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2006-5298", value:TRUE);
}
