#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:199
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24584);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5397");
 
 name["english"] = "MDKSA-2006:199: libx11";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:199 (libx11).

The Xinput module (modules/im/ximcp/imLcIm.c) in X.Org libX11 1.0.2 and
1.0.3 opens a file for reading twice using the same file descriptor,
which causes a file descriptor leak that allows local users to read
files specified by the XCOMPOSEFILE environment variable via the
duplicate file descriptor.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:199
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libx11 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libx11_6-1.0.3-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libx11_6-devel-1.0.3-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libx11_6-static-devel-1.0.3-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libx11-common-1.0.3-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libx11-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5397", value:TRUE);
}
