#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:201
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24586);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5170");
 
 name["english"] = "MDKSA-2006:201: pam_ldap";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:201 (pam_ldap).

Pam_ldap does not return an error condition when an LDAP directory
server responds with a PasswordPolicyResponse control response, which
causes the pam_authenticate function to return a success code even if
authentication has failed, as originally reported for xscreensaver.
This might lead to an attacker being able to login into a suspended
system account.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:201
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pam_ldap package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pam_ldap-180-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pam_ldap-180-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"pam_ldap-", release:"MDK2006.0")
 || rpm_exists(rpm:"pam_ldap-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5170", value:TRUE);
}
