#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:210
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24595);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3334", "CVE-2006-5793");
 
 name["english"] = "MDKSA-2006:210: syslinux";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:210 (syslinux).

SYSLINUX is a boot loader for the Linux operating system which operates
off an MS-DOS/Windows FAT filesystem. It is built with a private copy
of libpng, and as such could be susceptible to some of the same
vulnerabilities:
Buffer overflow in the png_decompress_chunk function in pngrutil.c in
libpng before 1.2.12 allows context-dependent attackers to cause a
denial of service and possibly execute arbitrary code via unspecified
vectors related to 'chunk error processing,' possibly involving the
'chunk_name'. (CVE-2006-3334)
It is questionable whether this issue is actually exploitable, but the
patch to correct the issue has been included in versions < 1.2.12.
Tavis Ormandy, of the Gentoo Linux Security Auditing Team, discovered a
typo in png_set_sPLT() that may cause an application using libpng to
read out of bounds, resulting in a crash. (CVE-2006-5793)
Packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:210
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the syslinux package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pxelinux-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"syslinux-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"syslinux-devel-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pxelinux-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"syslinux-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"syslinux-devel-3.20-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"syslinux-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-3334", value:TRUE);
 set_kb_item(name:"CVE-2006-5793", value:TRUE);
}
