#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:213
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24598);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2002-1363", "CVE-2004-0421", "CVE-2004-0597", "CVE-2004-0598", "CVE-2004-0599", "CVE-2006-3334");
 
 name["english"] = "MDKSA-2006:213: chromium";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:213 (chromium).

Chromium is an OpenGL-based shoot them up game with fine graphics. It
is built with a private copy of libpng, and as such could be
susceptible to some of the same vulnerabilities:
Buffer overflow in the png_decompress_chunk function in pngrutil.c in
libpng before 1.2.12 allows context-dependent attackers to cause a
denial of service and possibly execute arbitrary code via unspecified
vectors related to 'chunk error processing,' possibly involving the
'chunk_name'. (CVE-2006-3334)
It is questionable whether this issue is actually exploitable, but the
patch to correct the issue has been included in versions < 1.2.12.
In addition, an patch to address several old vulnerabilities has been
applied to this build. (CVE-2002-1363, CVE-2004-0421, CVE-2004-0597,
CVE-2004-0598, CVE-2004-0599)
Packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:213
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the chromium package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"chromium-0.9.12-25.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"chromium-setup-0.9.12-25.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"chromium-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2002-1363", value:TRUE);
 set_kb_item(name:"CVE-2004-0421", value:TRUE);
 set_kb_item(name:"CVE-2004-0597", value:TRUE);
 set_kb_item(name:"CVE-2004-0598", value:TRUE);
 set_kb_item(name:"CVE-2004-0599", value:TRUE);
 set_kb_item(name:"CVE-2006-3334", value:TRUE);
}
