#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:214-1
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24599);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5864");
 
 name["english"] = "MDKSA-2006:214-1: gv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:214-1 (gv).

Stack-based buffer overflow in the ps_gettext function in ps.c for GNU
gv 3.6.2, and possibly earlier versions, allows user-assisted attackers
to execute arbitrary code via a PostScript (PS) file with certain
headers that contain long comments, as demonstrated using the
DocumentMedia header.
Packages have been patched to correct this issue.
Update:
The patch used in the previous update still left the possibility of
causing X to consume unusual amounts of memory if gv is used to view a
carefully crafted image designed to exploit CVE-2006-5864. This update
uses an improved patch to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:214-1
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gv-3.6.1-4.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gv-3.6.1-7.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"gv-", release:"MDK2006.0")
 || rpm_exists(rpm:"gv-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5864", value:TRUE);
}
