#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:001
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24618);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4192");
 
 name["english"] = "MDKSA-2007:001: libmodplug";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:001 (libmodplug).

Multiple buffer overflows in MODPlug Tracker (OpenMPT) 1.17.02.43 and
earlier and libmodplug 0.8 and earlier allow user-assisted remote
attackers to execute arbitrary code via (1) long strings in ITP files
used by the CSoundFile::ReadITProject function in soundlib/Load_it.cpp
and (2) crafted modules used by the CSoundFile::ReadSample function in
soundlib/Sndfile.cpp, as demonstrated by crafted AMF files.
Updated packages are patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:001
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libmodplug package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libmodplug0-0.7-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmodplug0-devel-0.7-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libmodplug-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-4192", value:TRUE);
}
