#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:013
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24629);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0157");
 
 name["english"] = "MDKSA-2007:013: libneon0.26";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:013 (libneon0.26).

An array index error in the URI parser in neon 0.26.0 to 0.26.2 could
possibly allow remote malicious servers to cause a crash via a URI with
non-ASCII characters. This vulnerability may only exist on 64bit
systems.
Updated packages are patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:013
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libneon0.26 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libneon0.26-0.26.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libneon0.26-devel-0.26.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libneon0.26-static-devel-0.26.1-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libneon0.26-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0157", value:TRUE);
}
