#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:014
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24630);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6899");
 
 name["english"] = "MDKSA-2007:014: bluez-utils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:014 (bluez-utils).

hidd in BlueZ (bluez-utils) before 2.25 allows remote attackers to
obtain control of the (1) Mouse and (2) Keyboard Human Interface Device
(HID) via a certain configuration of two HID (PSM) endpoints, operating
as a server, aka HidAttack.
hidd is not enabled by default on Mandriva 2006.0. This update adds the
--nocheck option (disabled by default) to the hidd binary, which
defaults to rejecting connections from unknown devices unless --nocheck
is enabled.
The updated packages have been patched to correct this problem

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:014
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bluez-utils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bluez-utils-2.19-7.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bluez-utils-cups-2.19-7.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"bluez-utils-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-6899", value:TRUE);
}
