#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:027
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24641);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0254", "CVE-2007-0255");
 
 name["english"] = "MDKSA-2007:027: xine-ui";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:027 (xine-ui).

Format string vulnerability in the errors_create_window function in
errors.c in xine-ui allows attackers to execute arbitrary code via
unknown vectors. (CVE-2007-0254)
XINE 0.99.4 allows user-assisted remote attackers to cause a denial of
service (application crash) and possibly execute arbitrary code via a
certain M3U file that contains a long #EXTINF line and contains format
string specifiers in an invalid udp:// URI, possibly a variant of
CVE-2007-0017. (CVE-2007-0255)
The updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:027
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xine-ui package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xine-ui-0.99.4-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xine-ui-aa-0.99.4-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xine-ui-fb-0.99.4-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"xine-ui-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0254", value:TRUE);
 set_kb_item(name:"CVE-2007-0255", value:TRUE);
}
