#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:029
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24642);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5876");
 
 name["english"] = "MDKSA-2007:029: libsoup";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:029 (libsoup).

The soup_headers_parse function in soup-headers.c for libsoup HTTP
library before 2.2.99 allows remote attackers to cause a denial of
service (crash) via malformed HTTP headers, probably involving missing
fields or values.
The updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:029
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libsoup package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libsoup-2.2_7-2.2.3-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsoup-2.2_7-devel-2.2.3-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsoup-2.2_8-2.2.96-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsoup-2.2_8-devel-2.2.96-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libsoup-", release:"MDK2006.0")
 || rpm_exists(rpm:"libsoup-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2006-5876", value:TRUE);
}
