#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:033
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24646);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0456", "CVE-2007-0457", "CVE-2007-0458", "CVE-2007-0459");
 
 name["english"] = "MDKSA-2007:033: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:033 (wireshark).

Vulnerabilities in the LLT, IEEE 802.11, HTTP, and TCP dissectors were
discovered in versions of wireshark less than 0.99.5, as well as
various other bugs.
This updated provides wireshark 0.99.5 which is not vulnerable to these
issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:033
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwireshark0-0.99.5-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tshark-0.99.5-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.5-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-tools-0.99.5-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"wireshark-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0456", value:TRUE);
 set_kb_item(name:"CVE-2007-0457", value:TRUE);
 set_kb_item(name:"CVE-2007-0458", value:TRUE);
 set_kb_item(name:"CVE-2007-0459", value:TRUE);
}
