#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:042
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24655);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0472", "CVE-2007-0473", "CVE-2007-0474", "CVE-2007-0475");
 
 name["english"] = "MDKSA-2007:042: smb4k";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:042 (smb4k).

Kees Cook performed an audit on the Smb4K program and discovered a
number of vulnerabilities and security weaknesses that have been
addressed and corrected in Smb4K 0.8.0 which is being provided with
this update.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:042
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the smb4k package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libsmb4k0-0.8.0-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmb4k0-devel-0.8.0-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"smb4k-0.8.0-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"smb4k-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0472", value:TRUE);
 set_kb_item(name:"CVE-2007-0473", value:TRUE);
 set_kb_item(name:"CVE-2007-0474", value:TRUE);
 set_kb_item(name:"CVE-2007-0475", value:TRUE);
}
