#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:049
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24706);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0451");
 
 name["english"] = "MDKSA-2007:049: spamassassin";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:049 (spamassassin).

A bug in the way that SpamAssassin processes HTML emails containing
URIs was discovered in versions 3.1.x. A carefully crafted mail
message could make SpamAssassin consume significant amounts of CPU
resources that could delay or prevent the delivery of mail if a
number of these messages were sent at once.
SpamAssassin has been upgraded to version 3.1.8 to correct this
problem, and other upstream bugs. In addition, an invalid path setting
in local.cf for the auto_whitelist_path has been fixed for Mandriva
2007.0.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:049
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the spamassassin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"perl-Mail-SpamAssassin-3.1.8-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.8-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-spamc-3.1.8-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-spamd-3.1.8-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-tools-3.1.8-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"spamassassin-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-0451", value:TRUE);
}
