#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:059
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24809);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1263");
 
 name["english"] = "MDKSA-2007:059: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:059 (gnupg).

GnuPG prior to 1.4.7 and GPGME prior to 1.1.4, when run from the
command
line, did not visually distinguish signed and unsigned portions of
OpenPGP messages with multiple components. This could allow a remote
attacker to forge the contents of an email message without detection.
GnuPG 1.4.7 is being provided with this update and GPGME has been
patched on Mandriva 2007.0 to provide better visual notification on
these types of forgeries.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:059
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnupg-1.4.7-0.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.4.7-0.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgpgme11-1.1.2-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgpgme11-devel-1.1.2-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"gnupg-", release:"MDK2006.0")
 || rpm_exists(rpm:"gnupg-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1263", value:TRUE);
}
