#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:069
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24895);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1463");
 
 name["english"] = "MDKSA-2007:069: inkscape";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:069 (inkscape).

Format string vulnerability in Inkscape before 0.45.1 allows
user-assisted remote attackers to execute arbitrary code via format
string specifiers in a URI, which is not properly handled by certain
dialogs.
Updated packages have been patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:069
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the inkscape package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"inkscape-0.44-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"inkscape-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1463", value:TRUE);
}
