#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:082
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25033);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-4835", "CVE-2006-7177", "CVE-2006-7178", "CVE-2006-7179", "CVE-2006-7180");
 
 name["english"] = "MDKSA-2007:082: madwifi-source";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:082 (madwifi-source).

The ath_rate_sample function in the ath_rate/sample/sample.c sample
code in MadWifi before 0.9.3 allows remote attackers to cause a denial
of service (failed KASSERT and system crash) by moving a connected
system to a location with low signal strength, and possibly other
vectors related to a race condition between interface enabling and
packet transmission. (CVE-2005-4835)
MadWifi, when Ad-Hoc mode is used, allows remote attackers to cause
a denial of service (system crash) via unspecified vectors that lead
to a kernel panic in the ieee80211_input function, related to packets
coming from a malicious WinXP system. (CVE-2006-7177)
MadWifi before 0.9.3 does not properly handle reception of an AUTH
frame by an IBSS node, which allows remote attackers to cause a denial
of service (system crash) via a certain AUTH frame. (CVE-2006-7178)
ieee80211_input.c in MadWifi before 0.9.3 does not properly process
Channel Switch Announcement Information Elements (CSA IEs), which
allows remote attackers to cause a denial of service (loss of
communication) via a Channel Switch Count less than or equal to one,
triggering a channel change. (CVE-2006-7179)
ieee80211_output.c in MadWifi before 0.9.3 sends unencrypted packets
before WPA authentication succeeds, which allows remote attackers
to obtain sensitive information (related to network structure),
and possibly cause a denial of service (disrupted authentication)
and conduct spoofing attacks. (CVE-2006-7180)
Updated packages have been updated to 0.9.3 to correct this
issue. Wpa_supplicant is built using madwifi-source and has been
rebuilt using 0.9.3 source.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:082
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the madwifi-source package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"madwifi-source-0.9.3-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wpa_gui-0.5.5-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wpa_supplicant-0.5.5-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"madwifi-source-0.9.3-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"madwifi-source-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2005-4835", value:TRUE);
 set_kb_item(name:"CVE-2006-7177", value:TRUE);
 set_kb_item(name:"CVE-2006-7178", value:TRUE);
 set_kb_item(name:"CVE-2006-7179", value:TRUE);
 set_kb_item(name:"CVE-2006-7180", value:TRUE);
}
