#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:114
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25439);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2026", "CVE-2007-2799");
 
 name["english"] = "MDKSA-2007:114: file";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:114 (file).

The update to correct CVE-2007-1536 (MDKSA-2007:067), a buffer overflow
in the file_printf() function, introduced a new integer overflow as
reported by Colin Percival. This flaw, if an atacker could trick a
user into running file on a specially crafted file, could possibly
lead to the execution of arbitrary code with the privileges of the
user running file (CVE-2007-2799).
As well, in file 4.20, flawed regular expressions to identify OS/2
REXX files could lead to a denial of service via CPU consumption
(CVE-2007-2026).
The updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:114
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the file package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"file-4.17-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-4.17-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-devel-4.17-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-static-devel-4.17-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-magic-4.17-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"file-4.20-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-4.20-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-devel-4.20-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libmagic1-static-devel-4.20-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-magic-4.20-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"file-", release:"MDK2007.0")
 || rpm_exists(rpm:"file-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-2026", value:TRUE);
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}
