#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:145
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25698);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393");
 
 name["english"] = "MDKSA-2007:145: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:145 (wireshark).

A number of vulnerabilities in the Wireshark program were found that
could cause crashes, excessive looping, or exhaustion of system memory.
This updated provides wireshark 0.99.6 which is not vulnerable to
these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:145
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwireshark0-0.99.6-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tshark-0.99.6-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.6-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-tools-0.99.6-0.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwireshark0-0.99.6-0mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tshark-0.99.6-0mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.6-0mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-tools-0.99.6-0mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"wireshark-", release:"MDK2007.0")
 || rpm_exists(rpm:"wireshark-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
}
