#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:146
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25721);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3377", "CVE-2007-3409");
 
 name["english"] = "MDKSA-2007:146: perl-Net-DNS";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:146 (perl-Net-DNS).

A flaw was discovered in the perl Net::DNS module in the way it
generated the ID field in a DNS query. Because it is so predictable,
a remote attacker could exploit this to return invalid DNS data
(CVE-2007-3377).
A denial of service vulnerability was found in how Net::DNS parsed
certain DNS requests. A malformed response to a DNS request could
cause the application using Net::DNS to crash or stop responding
(CVE-2007-3409).
The updated packages have been patched to prevent these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:146
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the perl-Net-DNS package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"perl-Net-DNS-0.58-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.59-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"perl-Net-DNS-", release:"MDK2007.0")
 || rpm_exists(rpm:"perl-Net-DNS-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}
