#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:210
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27817);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4568", "CVE-2007-4990");
 
 name["english"] = "MDKSA-2007:210: xfs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:210 (xfs).

Integer overflow in the build_range function in X.Org X Font Server
(xfs) before 1.0.5 allows context-dependent attackers to execute
arbitrary code via (1) QueryXBitmaps and (2) QueryXExtents protocol
requests with crafted size values, which triggers a heap-based buffer
overflow. (CVE-2007-4568)
The swap_char2b function in X.Org X Font Server (xfs) before 1.0.5
allows context-dependent attackers to execute arbitrary code via (1)
QueryXBitmaps and (2) QueryXExtents protocol requests with crafted
size values that specify an arbitrary number of bytes to be swapped
on the heap, which triggers heap corruption. (CVE-2007-4990)
Updated package fixes these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:210
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xfs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xfs-1.0.2-13.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xfs-1.0.4-2.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"xfs-", release:"MDK2007.0")
 || rpm_exists(rpm:"xfs-", release:"MDK2007.1") )
{
 set_kb_item(name:"CVE-2007-4568", value:TRUE);
 set_kb_item(name:"CVE-2007-4990", value:TRUE);
}
