#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:212
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27849);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1659", "CVE-2007-1660");
 
 name["english"] = "MDKSA-2007:212: pcre";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:212 (pcre).

Multiple vulnerabilities were discovered by Tavis Ormandy and
Will Drewry in the way that pcre handled certain malformed regular
expressions. If an application linked against pcre, such as Konqueror,
parses a malicious regular expression, it could lead to the execution
of arbitrary code as the user running the application.
Updated packages have been patched to prevent this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:212
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pcre package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libpcre0-6.7-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpcre0-devel-6.7-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-6.7-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"pcre-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-1659", value:TRUE);
 set_kb_item(name:"CVE-2007-1660", value:TRUE);
}
