#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2007:240
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29298);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4135");
 
 name["english"] = "MDKSA-2007:240: libnfsidmap";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2007:240 (libnfsidmap).

The NFSv4 ID mapper prior to 0.17 did not properly handle return values
from the getpwnam_r() function when performing a username lookup, which
could cause it to report a file as being owned by 'root' instead of
'nobody' if the file exists on the server but not the client.
The updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2007:240
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libnfsidmap package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libnfsidmap0-0.17-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libnfsidmap0-devel-0.17-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libnfsidmap-", release:"MDK2007.0") )
{
 set_kb_item(name:"CVE-2007-4135", value:TRUE);
}
