#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25089);
  script_version("$Revision: 1.3 $");

  script_name(english:"McAfee E-Business Administration Agent Detection");
  script_summary(english:"Tries to perform initial handshake with EBSAdmin");

  desc = "
Synopsis :

An administration server is listening on the remote host. 

Description :

An Administration Agent for McAfee E-Business Server is listening on
the remote host.  McAfee E-Business Server is an enterprise tool for
digitally encrypting and signing electronic files, and the
Administration Agent allows for remote administration of the
E-Business Server on the remote host. 

See also :

http://www.mcafee.com/us/enterprise/products/encryption/ebusiness_server.html

Solution :

Limit incoming traffic to this port as desired.

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 1718);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery") ) {
  port = get_unknown_svc(1718);
  if (!port) exit(0);
}
else port = 1718;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Make sure we get the initial byte for a banner.
res = recv(socket:soc, length:2, min:1);
if (strlen(res) != 1 || getbyte(blob:res, pos:0) != 1) exit(0);


# Try to do the initial handshake.
req = raw_string(
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x25, 0x61, 0xa8, 0x4f, 0x21, 0x9e, 0x55, 0xc8, 
  0xca, 0x91, 0xc8, 0x88, 0x79, 0xa4, 0x31, 0xd5, 
  0x05, 0xff, 0x64, 0xc8, 0x8b, 0xac, 0x5a, 0x97, 
  0x18, 0x7e, 0x93, 0xa6, 0xa1, 0xed, 0x97, 0x79, 
  0x6e, 0x83, 0x30, 0xda, 0x91, 0xda, 0xc4, 0xd3, 
  0x46, 0x17, 0xb8, 0x1e, 0xf0, 0xf3, 0x8b, 0xd0, 
  0x6e, 0xb5, 0x9c, 0x37, 0x21, 0xe8, 0xeb, 0x7c, 
  0xd3, 0xc6, 0x9b, 0x63, 0xa2, 0x92, 0x21, 0x02, 
  0x2b, 0x3b, 0x0c, 0x9f, 0x08, 0x40, 0xd9, 0x29, 
  0x3f, 0x56, 0x06, 0x21, 0x1f, 0x86, 0x86, 0x21, 
  0xca, 0x06, 0xc6, 0x74, 0x15, 0x16, 0x4e, 0x37, 
  0x07, 0xdb, 0x01, 0x82, 0xc0, 0x20, 0xef, 0xff, 
  0x64, 0x74, 0x47, 0x59, 0x23, 0xa3, 0x80, 0xda, 
  0x21, 0x7e, 0x5f, 0x4f, 0x6d, 0x48, 0x89, 0x3f, 
  0xec, 0xec, 0xfd, 0x41, 0xdd, 0xb6, 0x2d, 0x76, 
  0x7b, 0xec, 0x7a, 0x5a, 0x00, 0xae, 0xc6, 0x47, 
  0x85, 0x06, 0xac, 0x58, 0xa3, 0x89, 0xa6, 0x50, 
  0x42, 0xb2, 0x82, 0x2a, 0xe7, 0xf6, 0x4a, 0xb6, 
  0x39, 0xbf, 0xd8, 0xaa, 0xe7, 0xc8, 0x4a, 0x3c, 
  0xc4, 0x69, 0xac, 0x89, 0x87, 0x68, 0xfc, 0x9f, 
  0x46, 0x63, 0x47, 0xee, 0x44, 0xc5, 0x03, 0xdf, 
  0x86, 0x5d, 0x9f, 0x34, 0xaf, 0x47, 0x46, 0x1e, 
  0x41, 0x60, 0xb4, 0x9e, 0x8e, 0x9e, 0x0e, 0xe8, 
  0xc8, 0x43, 0x6c, 0x35, 0xbb, 0x64, 0xe4, 0x2a, 
  0x76, 0x91, 0x5b, 0xaa, 0x0c, 0x8a, 0x21, 0x2d, 
  0xa6, 0x4c, 0x6b, 0xab, 0x2f, 0x6e, 0x8e, 0xd0, 
  0x08, 0xf7
);
req = mkbyte(1) + mkdword(strlen(req)) + req;
send(socket:soc, data:req);
res = recv(socket:soc, length:1024);
close(soc);


# If the response looks ok...
if (
  strlen(res) == 223 && 
  getbyte(blob:res, pos:0) == 2 && 
  getdword(blob:res, pos:1) + 5 == strlen(res)
)
{
  # Register and report the service.
  register_service(port:port, ipproto:"tcp", proto:"ebsadmin");
  security_note(port);
}
