#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25118);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-1578");
  script_bugtraq_id(23058);
  script_xref(name:"OSVDB", value:"33545");

  script_name(english:"MERCUR Messaging IMAP Server NTLM Authentication Buffer Overflow Vulnerability");
  script_summary(english:"Tries to crash MERCUR's IMAP Server");

  desc = "
Synopsis :

The remote mail server is vulnerable to a buffer overflow attack. 

Description :

The remote host is running MERCUR Messaging, a commercial mail server
for Windows. 

The IMAP server component of MERCUR Messaging is affected by a buffer
overflow vulnerability involving its support for NTLM authentication. 
An unauthenticated remote attacker can leverage this issue to crash
the IMAP service or execute arbitrary code remotely. 

Note that MERCUR Messaging's IMAP server runs as a service with LOCAL
SYSTEM privileges by default. 

See also :

http://www.milw0rm.com/exploits/3527

Solution :

Unknown at this time.

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  if (NASL_LEVEL >= 3000 )
    script_require_ports("Services/smtp", 25, "Services/pop3", 110, "Services/imap", 143, 32000);

  exit(0);
}


include("global_settings.inc");
include("imap_func.inc");
include("misc_func.inc");
include("pop3_func.inc");
include("smtp_func.inc");


# Do banner checks of various ports. 
#
# - SMTP.
port = get_kb_item("Services/smtp");
if (!port) port = 25;
banner = get_smtp_banner(port:port);
if (banner)
{
  # nb: banner for 2005 SP4 reads, in part, "MERCUR SMTP Server (v5.00.19".
  if (egrep(pattern:"^[0-9][0-9][0-9] .* MERCUR SMTP Server \(v([0-4]\.|5\.00\.(0[0-9]|1[0-9]))", string:banner))
  {
    security_hole(port);
    exit(0);
  }
  # Unless we're being paranoid, stop after getting the banner.
  if (report_paranoia < 2) exit(0);
}
# - POP3.
port = get_kb_item("Services/pop3");
if (!port) port = 110;
banner = get_pop3_banner(port:port);
if (banner)
{
  # nb: banner for 2005 SP4 reads, in part, "MERCUR POP3-Server (v5.00.12".
  if (egrep(pattern:"^(\+OK|-ERR) MERCUR POP3-Server \(v([0-4]\.|5\.00\.(0[0-9]|1[0-2]))", string:banner))
  {
    security_hole(port);
    exit(0);
  }
  # Unless we're being paranoid, stop after getting the banner.
  if (report_paranoia < 2) exit(0);
}
# - IMAP.
port = get_kb_item("Services/imap");
if (!port) port = 143;
banner = get_imap_banner(port:port);
if (banner)
{
  # nb: banner for 2005 SP4 reads, in part, "MERCUR IMAP4-Server (v5.00.14".
  if (egrep(pattern:"^\* (OK|BAD|NO) MERCUR IMAP4-Server \(v([0-4]\.|5\.00\.(0[0-9]|1[0-4]))", string:banner))
  {
    security_hole(port);
    exit(0);
  }
  # Unless we're being paranoid, stop after getting the banner.
  if (report_paranoia < 2) exit(0);
}
# - MERCUR Control Service
port = 32000;
banner = get_unknown_banner(port:port);
if (banner)
{
  # nb: banner for 2005 SP4 reads, in part, "MERCUR Control-Service (v5.00.14".
  if (egrep(pattern:"^MERCUR Control-Service \(v([0-4]\.|5\.00\.(0[0-9]|1[0-4]))", string:banner))
  {
    security_hole(port);
    exit(0);
  }
  # Unless we're being paranoid, stop after getting the banner.
  if (report_paranoia < 2) exit(0);
}
