#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30055);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2008-0782");
  script_bugtraq_id(27404);
  script_xref(name:"milw0rm", value:"4957");

  script_name(english:"MoinMoin Cookie Handling Vulnerability");
  script_summary(english:"Tries to generate an error using an invalid cookie");

  desc = "
Synopsis :

The remote web server contains a Python application that suffers from
an input sanitation vulnerability. 

Description :

The remote host is running MoinMoin, a wiki application written in
Python. 

The version of MoinMoin installed on the remote host fails to validate
input to the 'MOIN_ID' cookie before using it to read and write user
profiles.  By providing the name of a file that exists on the remote
host and is writable by the web server user id, an unauthenticated
remote attacker may be able to exploit this issue to corrupt files,
possibly even injecting arbitrary PHP code that could later be
executed subject to the privileges of the web server user id. 

See also :

http://hg.moinmo.in/moin/1.5/rev/e69a16b6e630

Solution :

Apply the patches referenced in the project's advisory above. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/moinmoin", "/wiki", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  if (strlen(dir) == 0) dir = "/";

  # Pass in an invalid cookie.
  req = http_get(item:dir, port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: MOIN_ID=.\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if there's an error related to the cookie.
  if (
    '>IOError<' >< res && '>[Errno 21]' >< res &&
    "auth_method='moin_cookie'" >< res && '/MoinMoin/user.py' >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
