#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24874);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-1647");

  script_name(english:"Moodle moodledata Information Disclosure Vulnerability");
  script_summary(english:"Checks whether moodledata is accessible");
 
  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an information disclosure vulnerability. 

Description :

The version of Moodle on the remote host allows a remote attacker to
browse session files, which likely contain sensitive information about
users of the application, such as password hashes and email addresses. 

See also :

http://www.milw0rm.com/exploits/3508
http://docs.moodle.org/en/Configuration_file

Solution :

Either configure the web server to prevent directory listing or
configure the application so its 'dataroot' is located outside the web
server's documents directory. 

Risk factor : 

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:C/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("moodle_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/moodle"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Get the session id.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  sid = NULL;
  pat = "Set-Cookie: MoodleSession=([^; ]+)";
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      val = eregmatch(pattern:pat, string:match);
      if (!isnull(val))
      {
        sid = val[1];
        break;
      }
    }
  }

  # If we have a session cookie...
  if (!isnull(sid))
  {
    # Try to exploit the flaw.
    req = http_get(item:string(dir, "/moodledata/sessions/"), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if our session file shows up in the listing.
    if (string('href="sess_', sid, '">sess_') >< res)
      security_hole(port);
  }
}
