#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Marcel Boesch <marboesc@student.ethz.ch>.
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14668);
 script_bugtraq_id(10703);
 script_cve_id("CVE-2004-0758");
 script_xref(name:"OSVDB", value:"8306");
 script_version("$Revision: 1.12 $");

 name["english"] = "Mozilla/Firefox security manager certificate handling DoS";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Mozilla, an alternative web browser.

The Mozilla Personal Security Manager (PSM) contains  a flaw
that may permit a attacker to import silently a certificate into
the PSM certificate store.
This corruption may result in a deny of SSL connections.

Solution : Upgrade to the latest version of this software
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla/Firefox";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 if ( NASL_LEVEL >= 3206 ) script_require_ports("Mozilla/Version", "Mozilla/Firefox/Version", "Mozilla/Thunderbird/Version");
 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Version");
if (!isnull(ver)) 
{
  if (
    ver[0] < 1 ||
    (
      ver[0] == 1 &&
      (
        ver[1] < 7 ||
        (ver[1] == 7 && ver[2] < 1)
      )
    )
  )  security_warning(get_kb_item("SMB/transport"));
}

ver = read_version_in_kb("Mozilla/Firefox/Version");
if (!isnull(ver))
{
  if (
    ver[0] == 0 && 
    (
      ver[1] < 9 ||
      (ver[1] == 9 && ver[2] < 3)
    )
  )  security_warning(get_kb_item("SMB/transport"));
}

ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (!isnull(ver))
{
  if (ver[0] == 0 && ver[1] < 8)
    security_warning(get_kb_item("SMB/transport"));
}
