#
# (C) Tenable Network Security
#

if(description)
{
 script_id(18689);
 script_version("$Revision: 1.9 $");

 script_cve_id(
    "CVE-2005-1937",
    "CVE-2005-2260",
    "CVE-2005-2261",
    "CVE-2005-2262",
    "CVE-2005-2263",
    "CVE-2005-2264",
    "CVE-2005-2265",
    "CVE-2005-2266",
    "CVE-2005-2267",
    "CVE-2005-2268",
    "CVE-2005-2269",
    "CVE-2005-2270",
    "CVE-2005-2395"
  );
 script_bugtraq_id(14242, 14325);

 name["english"] = "Firefox < 1.0.6";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote Windows host contains a web browser that is affected by
multiple vulnerabilities. 

Description :

The remote version of Firefox contains various security issues that
may allow an attacker execute arbitrary code on the remote host. 

See also :

http://www.mozilla.org/security/announce/2005/mfsa2005-45.html
http://www.mozilla.org/security/announce/2005/mfsa2005-46.html
http://www.mozilla.org/security/announce/2005/mfsa2005-47.html
http://www.mozilla.org/security/announce/2005/mfsa2005-48.html
http://www.mozilla.org/security/announce/2005/mfsa2005-49.html
http://www.mozilla.org/security/announce/2005/mfsa2005-50.html
http://www.mozilla.org/security/announce/2005/mfsa2005-51.html
http://www.mozilla.org/security/announce/2005/mfsa2005-52.html
http://www.mozilla.org/security/announce/2005/mfsa2005-53.html
http://www.mozilla.org/security/announce/2005/mfsa2005-54.html
http://www.mozilla.org/security/announce/2005/mfsa2005-55.html
http://www.mozilla.org/security/announce/2005/mfsa2005-56.html

Solution : 

Upgrade to Firefox 1.0.6 or later.

Risk factor : 

High / CVSS Base Score : 8 
(AV:R/AC:H/Au:NR/C:C/I:C/A:C/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Firefox";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 script_require_keys("Mozilla/Firefox/Version");
 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 6)
) security_hole(get_kb_item("SMB/transport"));
