#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30209);
  script_version("$Revision: 1.4 $");

  script_cve_id(
    "CVE-2008-0412",
    "CVE-2008-0413",
    "CVE-2008-0414",
    "CVE-2008-0415",
    "CVE-2008-0417",
    "CVE-2008-0418",
    "CVE-2008-0419",
    "CVE-2008-0420",
    "CVE-2008-0591",
    "CVE-2008-0592",
    "CVE-2008-0593",
    "CVE-2008-0594"
  );
  script_bugtraq_id(24293, 27406, 27683, 27826);

  script_name(english:"Firefox < 2.0.0.12");
  script_summary(english:"Checks version of Firefox");

  desc = "
Synopsis :

The remote Windows host contains a web browser that is affected by
multiple vulnerabilities. 

Description :

The installed version of Firefox is affected by various security
issues :

  - Several stability bugs leading to crashes which, in
    some cases, show traces of memory corruption

  - Several file input focus stealing vulnerabilities
    that could result in uploading of arbitrary files
    provided their full path and file names are known.

  - Several issues that allow scripts from page content 
    to escape from their sandboxed context and/or run 
    with chrome privileges, resulting in privilege 
    escalation, XSS, and/or remote code execution.

  - An issue that could allow a malicious site to inject
    newlines into the application's password store when
    a user saves his password, resulting in corruption
    of saved passwords for other sites.  

  - A directory traversal vulnerability via the 
    'chrome:' URI.

  - A vulnerability involving 'designMode' frames that
    may result in web browsing history and forward 
    navigation stealing.

  - An information disclosure issue in the BMP 
    decoder.

  - A file action dialog tampering vulnerability
    involving timer-enabled security dialogs.

  - Mis-handling of locally-saved plain text files.

  - Possible disclosure of sensitive URL parameters,
    such as session tokens, via the .href property of 
    stylesheet DOM nodes reflecting the final URI of 
    the stylesheet after following any 302 redirects.

  - A failure to display a web forgery warning 
    dialog in cases where the entire contents of a page 
    are enclosed in a '<div>' with absolute positioning.

See also :

http://www.mozilla.org/security/announce/2008/mfsa2008-01.html
http://www.mozilla.org/security/announce/2008/mfsa2008-02.html
http://www.mozilla.org/security/announce/2008/mfsa2008-03.html
http://www.mozilla.org/security/announce/2008/mfsa2008-04.html
http://www.mozilla.org/security/announce/2008/mfsa2008-05.html
http://www.mozilla.org/security/announce/2008/mfsa2008-06.html
http://www.mozilla.org/security/announce/2008/mfsa2008-07.html
http://www.mozilla.org/security/announce/2008/mfsa2008-08.html
http://www.mozilla.org/security/announce/2008/mfsa2008-09.html
http://www.mozilla.org/security/announce/2008/mfsa2008-10.html
http://www.mozilla.org/security/announce/2008/mfsa2008-11.html

Solution :

Upgrade to Firefox 2.0.0.12 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Firefox/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Firefox/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 2 ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 12)
) security_hole(get_kb_item("SMB/transport"));
