#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31193);
  script_version("$Revision: 1.4 $");

  script_cve_id(
    "CVE-2008-0304",
    "CVE-2008-0412",
    "CVE-2008-0413",
    "CVE-2008-0415",
    "CVE-2008-0418"
  );
  script_bugtraq_id(27406, 27683, 28012);

  script_name(english:"Mozilla Thunderbird < 2.0.0.12");
  script_summary(english:"Checks version of Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The installed version of Thunderbird is affected by various security
issues :

  - Several stability bugs leading to crashes which, in
    some cases, show traces of memory corruption

  - Several issues that allow scripts from page content 
    to escape from their sandboxed context and/or run 
    with chrome privileges, resulting in privilege 
    escalation, XSS, and/or remote code execution.

  - A directory traversal vulnerability via the 
    'chrome:' URI.

  - A heap buffer overflow that can be triggered
    when viewing an email with an external MIME 
    body.

See also :

http://www.mozilla.org/security/announce/2008/mfsa2008-01.html
http://www.mozilla.org/security/announce/2008/mfsa2008-03.html
http://www.mozilla.org/security/announce/2008/mfsa2008-05.html
http://www.mozilla.org/security/announce/2008/mfsa2008-12.html

Solution :

Upgrade to Mozilla Thunderbird 2.0.0.12 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 2 ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 12)
) security_hole(get_kb_item("SMB/transport"));
