#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25754);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3734", "CVE-2007-3735");
  script_bugtraq_id(24286);

  script_name(english:"Mozilla Thunderbird < 2.0.0.5");
  script_summary(english:"Checks version of Mozilla Thunderbird");
 
  desc = "
Synopsis :

The remote Windows host contains a mail client that is affected by
multiple vulnerabilities. 

Description :

The remote version of Mozilla Thunderbird suffers from various
security issues, at least one that may lead to execution of arbitrary
code on the affected host subject to the user's privileges. 

See also : 

http://www.mozilla.org/security/announce/2007/mfsa2007-18.html
http://www.mozilla.org/security/announce/2007/mfsa2007-23.html

Solution :

Upgrade to Mozilla Thunderbird 2.0.0.5 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("Mozilla/Thunderbird/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 2 ||
  (ver[0] == 2 && ver[1] == 0 && ver[2] == 0 && ver[3] < 5)
) security_hole(get_kb_item("SMB/transport"));
