#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30219);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0659");
  script_bugtraq_id(27533);
  script_xref(name:"milw0rm", value:"5025");
  script_xref(name:"Secunia", value:"28715");

  script_name(english:"MySpace Uploader ActiveX Control < 1.0.0.6 Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of affected ActiveX control"); 
 
 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by a
buffer overflow vulnerability. 

Description :

The remote host contains a version of the MySpace Uploader ActiveX
control (MySpace.Uploader.4.1) that reportedly is affected by a buffer
overflow that can be triggered by assigning a string longer than 260
characters to certain properties, such as 'Action', 'ExtractIptc', and
'ExtractExif'.  If a remote attacker can trick a user on the affected
host into visiting a specially-crafted web page, he may be able to
leverage this issue to execute arbitrary code on the affected host
subject to the user's privileges. 

See also :

http://lists.grok.org.uk/pipermail/full-disclosure/2008-January/059980.html

Solution :

Upgrade to version 1.0.0.6 of the control as that reportedly resolves
the issue. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the control.
if (activex_init() != ACX_OK) exit(0);

clsid = "{48DD0448-9209-4F81-9F6D-D83562940134}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"1.0.0.6") == TRUE)
  {
    report = NULL;
    if (report_paranoia > 1)
      report = string(
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Note, though, that Nessus did not check whether the 'kill' bit was\n",
        "set for the control's CLSID because of the Report Paranoia setting\n",
        "in effect when this scan was run.\n"
      );
    else if (activex_get_killbit(clsid:clsid) != TRUE)
      report = string(
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Moreover, its 'kill' bit is not set so it is accessible via Internet\n",
        "Explorer.\n"
      );
    if (report)
    {
      if (report_verbosity) security_hole(port:kb_smb_transport(), extra:report);
      else security_hole(kb_smb_transport());
    }
  }
}
activex_end();
