#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Ref: http://www.mysql.com/doc/en/News-3.23.55.html
# 
#

if(description)
{
 script_id(11299);  
 script_bugtraq_id(6718);
 script_version ("$Revision: 1.16 $");
 script_cve_id("CVE-2003-0073");
 if ( defined_func("script_xref") ) script_xref(name:"RHSA", value:"RHSA-2003:093-01");

 
 name["english"] = "MySQL < 3.23.55";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Synopsis :

The remote database service is prone to a denial of service attack. 

Description :

According to its banner, a version of MySQL before 3.23.55 is running
on the remote host.  If you have not patched this version, then an
attacker with valid credentials may be able to crash this service
remotely by exploiting a double free bug. 

Further exploitation to gain a shell on the host might be possible,
although it's unconfirmed so far. 

Solution : 

Upgrade to MySQL 3.23.55 or newer.

Low / CVSS Base Score : 1.4
(AV:R/AC:L/Au:R/C:N/I:N/A:P/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the remote MySQL version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "Databases";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "mysql_version.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

#
# The script code starts here
#

include("misc_func.inc");

port = get_kb_item("Services/mysql");
if(!port)port = 3306;

ver=get_mysql_version(port:port);
if (isnull(ver)) exit(0);
if(ereg(pattern:"^3\.(([0-9]\..*|(1[0-9]\..*)|(2[0-2]\..*))|23\.([0-4][0-9]|5[0-4])[^0-9])", string:ver))security_note(port);	  

