#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30057);
  script_version("$Revision: 1.2 $");

  script_name(english:"nagios-statd Daemon Detection");
  script_summary(english:"Sends commands such as 'version', 'disk', and 'proc'");

  desc = "
Synopsis :

A system monitoring service is listening on the remote host. 

Description :

The remote service is a nagios-statd daemon, a system monitoring tool
designed to be integrated with Nagios, although it can also be used
without that. 

See also :

http://www.twoevils.org/files/netsaint_statd/

Solution :

Limit incoming traffic to this port as it can reveal sensitive
information about the remote host. 

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/unknown", 1040);

  exit(0);
}



include("global_settings.inc");
include("misc_func.inc");


if (
  thorough_tests &&
  !get_kb_item("global_settings/disable_service_discovery")
)
{
  port = get_unknown_svc(1040);
  if (!port) exit(0);
  if (silent_service(port)) exit(0); 
}
else port = 1040;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


# Send a "version" command.
tries = 5;
for (i=0; i<tries; i++)
{
  soc = open_sock_tcp(port);
  if (soc)
  {
    req = "version";
    send(socket:soc, data:string(req, "\r\n"));
    res = "";
    while (line = recv_line(socket:soc, length:80))
      res += line;
    close(soc);

    if (strlen(res)) break;
    else sleep(1);
  }
}
if (res == NULL) exit(0);

# If it's nagios-statd...
if (strlen(res) && "nagios-statd" >< res)
{
  # Extract version if possible.
  ver = strstr(res, "nagios-statd") - "nagios-statd";
  if (ver =~ " [0-9]+\.")
  {
    ver = ver - " ";
    set_kb_item(name:"nagios_statd/"+port+"/Version", value:ver);
  }
  else ver = "";

  # Register and report the service.
  register_service(port:port, ipproto:"tcp", proto:"nagios_statd");

  if (report_verbosity)
  {
    # Collect some info for the report.
    info = "";
    # - version.
    if (ver) info += '  Version    : ' + ver + '\n\n';
    # - disk check.
    soc = open_sock_tcp(port);
    if (soc)
    {
      req = "disk";
      send(socket:soc, data:string(req, "\r\n"));
      res = "";
      while (line = recv_line(socket:soc, length:80))
        res += '    ' + line;
      if (strlen(res)) info += '  Disk usage :\n' + res + '\n';
      close(soc);
    }
    # - processes check.
    soc = open_sock_tcp(port);
    if (soc)
    {
      req = "proc";
      send(socket:soc, data:string(req, "\r\n"));
      res = "";
      while (line = recv_line(socket:soc, length:80))
        res += '    ' + line;
      if (strlen(res)) info += '  Processes  :\n' + res + '\n';
      close(soc);
    }

    report = string(
      "\n",
      "Nessus collected the following information from the remote\n",
      "nagios-statd daemon :\n",
      "\n",
      info
    );
    security_note(port, extra:report);
  }
  else security_note(port);
}
