# netscaler_web_unencrypted.nasl
# GPLv2


if (description)
    {
    script_id(29224);
    script_version("$Revision: 1.2 $");
    name["english"]="Unencrypted NetScaler web management interface";
    desc["english"]="
Synopsis :

The remote web management interface does not encrypt connections. 

Description :

The remote Citrix NetScaler web management interface does use TLS or
SSL to encrypt connections. 

Solution :

Consider disabling this port completely and using only HTTPS. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
    summary["english"]="Detects an unencrypted NetScaler web management interface";
    family["english"]="Web Servers";
    script_name(english:name["english"]);
    script_description(english:desc["english"]);
    script_summary(english:summary["english"]);
    script_family(english:family["english"]);
    script_category(ACT_GATHER_INFO);
    script_copyright(english:"This script is Copyright (c) 2007 nnposter");
    script_dependencies("netscaler_web_detect.nasl");
    script_require_keys("www/netscaler");
    script_require_ports("Services/www",80);
    exit(0);
    }


if (!get_kb_item("www/netscaler")) exit(0);


include("http_func.inc");


function is_ssl(port)
{
local_var encaps;
encaps= get_kb_item("Transports/TCP/"+port);
if ( encaps && encaps>=ENCAPS_SSLv2 && encaps<=ENCAPS_TLSv1 )
	return TRUE;
 else
	return FALSE;
}


port=get_http_port(default:80);
if (!get_tcp_port_state(port) || !get_kb_item("www/netscaler/"+port))
    exit(0);

if (!is_ssl(port:port)) security_warning(port);
