#TRUSTED 9a961f9abac04f810d8cd6fe5aa3360bfc97f7a0884045a62f0cf9adf9f03b624ad6389a346397e230ee9069c6589c64725b1527b850a55be085a18961806d95b1318380a7135c4dc4f18e809d58af35c312719a97c777d35e3336a838e3be0c14d2b7dc4ca656141d800c997d92f8390da8d4c2c1ec0a705e633646daee5cae5417dcdbe37d7fd2f6a866cc6624a092f803faf99ffefbe4e301e7887e664a6c06ab37117fd55103c9250f2ff0aabd0bdf94761e89b74710f9df9dc18a7090251fd51a06827845da85378c7b517f62289a46e6c0b658a5f9a831acb354cf70d36c5f106c0ad6dbd3c44a9fa43b461666380de5b810a8f90c3fc0b00a0007fc72b633f3cc1807956ed71476eae63ab550d256261d433b4f01625ac75b8db6c3456c44230a1429af7939699f88d31dcd4eb3c8804578bc671f3686efb0f8370cd293423fe6c64f0f8e612fbc855c03ec4cc43477f3733cc5071918f83d8d227c686f87dc3bc83e30e63b408eb8439e4f262166526ed52435c0929ac48b277799b469d59dbb58839d05cf3ec0549d7740c97a31d54e1c5ab57856a5d827408a6bbff50043852c2ddbd6c6c0b9728a664c25f3e3ef58d935cc414a7f34b3b353c46d0acd1c875870082d8e20e4302274f07348d0237ebd1ed166bd846d62ce7332145ba81eaf7168b50bafd3ef76bf5d77f43feb3f56f6c36f73ca7556050b3022b6
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#



if(description)
{
 script_id(14272);
 script_version ("1.10");
 name["english"] = "Netstat 'scanner'";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs netstat on the remote machine to find open ports.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find open ports with netstat";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SCANNER);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Port scanners";
 family["francais"] = "Scanners de ports";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("ping_host.nasl", "ssh_settings.nasl");
 exit(0);
}

#
include("ssh_func.inc");

buf = "";

# On the local machine, just run the command
if (islocalhost())
{
  if ( ! defined_func("pread") ) exit(0);
  buf = pread(cmd: "netstat", argv: make_list("netstat", "-a", "-n"));
}
else
{
# First try the netstat service, just in case
 s = open_sock_tcp(15);
 if (s)
 {
   linenb = 0;
   while (r = recv(socket: s, length: 4096))
    {
     buf += r;
     linenb++;
     if ( linenb > 1024 ) break;
    }
   close(s);
 }
# Then try SSH if the result is not OK
 if ("LISTEN" >!< buf)
 {
 sock = ssh_login_or_reuse_connection();
 if (! sock)  exit(0);

 buf = ssh_cmd(socket:sock, cmd:"cmd /c netstat -an", timeout:60);

 if ("LISTENING" >!< buf && "0.0.0.0:0" >!< buf && "*.*" >!< buf)
 {
 buf = ssh_cmd(socket:sock, cmd:"netstat -a -n", timeout:60);
 if (! buf) { display("could not send command\n"); ssh_close_connection(); exit(0); }
 }
 ssh_close_connection();
}
}

# display(buf);
ip = get_host_ip();
lines = split(buf);
n = max_index(lines);
if (n == 0) n = 1; i = 0;
scanner_status(current: 0, total: n);
scanned = 0;
check = 
 (! safe_checks()) ||
 ("yes" >< get_kb_item("global_settings/experimental_scripts_tests")) ||
 ("yes" >< get_preference("unscanned_closed")) ||
 ("yes" >< get_kb_item("global_settings/thorough_tests"));
# ("Avoid false alarms" >< get_kb_item("global_settings/report_paranoia"))

identd_n = 0; identd_err = 0;

foreach line (lines)
{
  # Windows
  v = eregmatch(pattern: '^[ \t]+(TCP|UDP)[ \t]+([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+):([0-9]+)[ \t]+(0\\.0\\.0\\.0:0|\\*\\.\\*)[ \t]+', string: line, icase: 0);
  # Unix
  if (isnull(v))
   v = eregmatch(pattern: '^(tcp|udp)[46]?[ \t]+.*[ \t]+(\\*|[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)[:.]([0-9]+)[ \t]+(.*[ \t]+LISTEN|0\\.0\\.0\\.0:\\*)', string: line, icase: 1);
  if (isnull(v))
  # tcp 0 0 :::22   :::*    LISTEN
  # tcp 0 0 ::1:25  :::*    LISTEN (1 = localhost)
  v = eregmatch(pattern: '^(tcp|udp)[ \t]+.*[ \t]+(:::)([0-9]+)[ \t]+.*[ \t]+LISTEN', string: line, icase: 1);

  # Solaris 9
  if (isnull(v))
  {
    if (last_seen_proto)
    {
      if (last_seen_proto == 'udp')
        v = eregmatch(pattern: '^[ \t]*(\\*|[0-9.]+)\\.([0-9]+)[ \t]+Idle', string: line);
      else
        v = eregmatch(pattern: '^[ \t]*(\\*|[0-9.]+)\\.([0-9]+)[ \t]+\\*\\.\\*[ \t]+.*(Idle|LISTEN)', string: line);
      
      if (! isnull(v))
      {
        # "Fix" array
        v[3] = v[2]; v[2] = v[1]; v[1] = last_seen_proto;
      }
    }
    if (isnull(v))
    {
      v = eregmatch(pattern: '^(TCP|UDP): +IPv4[ \t\r\n]*$', string: line);
      if (!isnull(v))
      {
        last_seen_proto = tolower(v[1]);
        v = NULL;
      }
    }
  }
  

  if (!isnull(v))
  {
    if (check && defined_func("get_source_port"))
      identd_soc = open_sock_tcp(113);
    proto = tolower(v[1]);
    addr = v[2];
    port = v[3];
    # display("> ", addr, ":", port, " (", proto, ")\n");
    if (port < 1 || port > 65535)
     display('netstat_portscan(', get_host_ip(), '): invalid port number ', port, '\n');
    else if ((check && addr != "127.0.0.1") || 
        addr == "0.0.0.0" || addr == ip || addr == ":::" || addr == '*')
    {
      if (check && proto == "tcp")
      {
        soc = open_sock_tcp(port);
        if (soc)
        {
          scanner_add_port(proto: proto, port: port);
	  if (identd_soc)
	  {
	    req = strcat(port, ',', get_source_port(soc), '\r\n');
	    if (send(socket: identd_soc, data: req) <= 0)
	    {
	      # Let's be quick: do not reopen the socket if an error occurs
	      # Another plugin with complete the job
	      close(identd_soc);
	      identd_soc = NULL;
	      identd_err ++;
	      id = NULL;
	    }
	    else
	      id = recv_line(socket: identd_soc, length: 1024);
	    if (id)
	    {
	      ids = split(id, sep: ':');
	      if ("USERID" >< ids[1])
              {
		identd_n ++;
		set_kb_item(name: "Ident/tcp/"+port, value: ids[3]);
		security_note(port: port, 
data: 'identd reveals that this service is running as user '+ids[3]);
	      }
	    }
	  }
          close(soc);
        }
      }
      else
      scanner_add_port(proto: proto, port: port);
      # display(proto, "\t", port, "\n");
    }
    scanned ++;
  }
  scanner_status(current: i++, total: n);
}

if (identd_soc) close(identd_soc);

if (scanned)
{
 set_kb_item(name: "Host/scanned", value: TRUE);
 set_kb_item(name: "Host/udp_scanned", value: TRUE);
 set_kb_item(name: "Host/full_scan", value: TRUE);
 set_kb_item(name: 'Host/scanners/netstat', value: TRUE);
 if (identd_n && ! identd_err)
   set_kb_item(name: "Host/ident_scanned", value: TRUE);
}

scanner_status(current: n, total: n);
exit(0);
