#TRUSTED 5472ec8426675bd458b0ccf833baec43f214b4cf6f76b05262026d0b5f1ac6a92fb2da9d7ac0b818ceba370b8c3fa142a067681cd21f15d68647a5bfaaf21355e99003efa196d19bd36488ca3e364e62002dcf3832fb3b07b9093325534a476e763a6d2c7a70dd48b235ec0d18a17e74b8245658b1a3d8dfc457114a6839aaeb66b2890ea8aed925abc6e609007d6fd243e3252df48a06b33a2afc0def839b8316e5dfe79961a65c664c04431a7ea7901eb94e10e88227ca2c255d3ec1b5239de9da9d40efd863508ad172dbccf7380fa4a1571a478bc5b1c9d0366424cad7d7f0e26fac87fd3e73ad6daebfccb3991de06044729213e22e4742c30dd5eec79b5297708f91b980cacb315c72e1915961f033d098dbe9ada7addc9fd5d349bc798701badc2299a77b921d495cb9218b5c4dbb49cd4a4cc8a618fe078cd620c43c6676e3c8dbfb6ccbe6b09b919bf7cb03eca12cd25723f5918db90944dcfa788ae84a225c4448fdd529b91aed4ede27116f1e3e913170a0b66f7a26b61b1095f941a7b45537e1be3c74ccca77a8fe6d290149d4a2f93b131e53be4d0b6f46fab87be6ce75859f7618cf1754ac79a1151180a160453aaa50a261836323f85c2eca1a7475031932adb66b322610754e32ad22dd5de1d3c63a1bfc9ce935687f15bcb2e3893b31e1e5515d2cfec9e0024c0bbe328508e38036b5d234a26de1191bf5
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread")) exit(0);
if ( ! find_in_path("nikto.pl") ) exit(0);


if(description)
{
 script_id(14260);
 script_version ("1.15");
 name["english"] = 
 script_name(english: "Nikto (NASL wrapper)");
 
 desc = "
This plugin runs nikto2 to find CGI.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc);
 
 script_summary(english: "Find CGI with Nikto2");
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2008 Michel Arboi");
 script_family(english: "CGI abuses");
 script_dependencies("find_service1.nasl", "httpver.nasl", "logins.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

 script_add_preference(name:"Enable Nikto", type:"checkbox", value:"no");

 script_add_preference(name:"Root directory", type:"entry", value:"");
 script_add_preference(name:"Pause between tests (s)", type:"entry", value:"");
 script_add_preference(name:"Scan CGI directories",
                       type:"radio", value:"User supplied;All;None");
 script_add_preference(name:"Single request monde",
                       type:"checkbox", value:"no");

 script_add_preference(type: "checkbox", value: "no", name: "Display: 1 Show redirects");
 script_add_preference(type: "checkbox", value: "no", name: "Display: 2 Show cookies received");
 script_add_preference(type: "checkbox", value: "no", name: "Display: 3 Show all 200/OK responses");
 script_add_preference(type: "checkbox", value: "no", name: "Display: 4 Show URLs which require authentication");
 script_add_preference(type: "checkbox", value: "no", name: "Display: D Debug Output");
 script_add_preference(type: "checkbox", value: "no", name: "Display: V Verbose Output");

 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 1 Interesting File / Seen in logs");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 2 Misconfiguration / Default File");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 3 Information Disclosure");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 4 Injection (XSS/Script/HTML)");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 5 Remote File Retrieval - Inside Web Root");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 6 Denial of Service");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 7 Remote File Retrieval - Server Wide");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 8 Command Execution / Remote Shell");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 9 SQL Injection");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: 0 File Upload");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: a Authentication Bypass");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: b Software Identification");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: c Remote Source Inclusion");
 script_add_preference(type: "checkbox", value: "no", name: "Tuning: x Reverse Tuning Options (i.e., include all except specified)");

 script_add_preference(type: "checkbox", value: "no", name: "Mutate: 1 Test all files with all root directories");
 script_add_preference(type: "checkbox", value: "no", name: "Mutate: 2 Guess for password file names");
 script_add_preference(type: "checkbox", value: "no", name: "Mutate: 3 Enumerate user names via Apache (/~user type requests)");
 script_add_preference(type: "checkbox", value: "no", name: "Mutate: 4 Enumerate user names via cgiwrap (/cgi-bin/cgiwrap/~user type requests)");

 exit(0);
}

#

function my_cgi_dirs()	# Copied from http_func.inc
{
 local_var	kb;
 kb = get_kb_list("/tmp/cgibin");
 if(isnull(kb)) kb = make_list("/cgi-bin", "/scripts", "");
 else kb = make_list(kb, "");
}

if (! COMMAND_LINE)
{
 p = script_get_preference("Enable Nikto");
 if ( "yes" >!< p ) exit(0);
}

if (! defined_func("pread"))
{
  set_kb_item(name: "/tmp/UnableToRun/14254", value: TRUE);
  display("Script #14254 (nikto_wrapper) cannot run\n");
  exit(0);
}

user = get_kb_item("http/login");
pass = get_kb_item("http/password");
ids = get_kb_item("/Settings/Whisker/NIDS");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

# Nikto will generate many false positives if the web server is broken
no404 = get_kb_item("www/no404/" + port);
if ( no404 ) exit(0);

i = 0;
argv[i++] = "nikto.pl";

p = script_get_preference("Scan CGI directories");
if (p)
if ("User supplied" >!< p)
{
 argv[i++] = "-Cgidirs";
 argv[i++] = tolower(p);
}
else
{
 v = my_cgi_dirs();
 n = 0;
 if (! isnull(v))   n = max_index(v);
 if (n > 0)
 {
  l = "";
  for (j = 0; j < n; j ++)
  {
   l = strcat(l, v[j]);
   if (! match(string: v[j], pattern: "*/")) l = strcat(l, "/");
   l = strcat(l, " ");
  }
  argv[i++] = "-Cgidirs";
  argv[i++] = l;
 }
}

httpver = get_kb_item("http/"+port);
if (httpver == "11")
{
  argv[i++] = "-vhost";
  argv[i++] = get_host_name();
}

display='';
l = make_list("Display: 1 Show redirects", 
	"Display: 2 Show cookies received",
	"Display: 3 Show all 200/OK responses", 
	"Display: 4 Show URLs which require authentication",
	"Display: D Debug Output",
	"Display: V Verbose Output");

foreach opt (l)
{
 p = script_get_preference(opt);
 if ("yes" >< p) display = strcat(display, substr(opt, 9, 9));
}

if (display)
{
 argv[i++] = "-Display";
 argv[i++] = display;
}

mutate = '';
l = make_list("Mutate: 1 Test all files with all root directories",
	"Mutate: 2 Guess for password file names",
	"Mutate: 3 Enumerate user names via Apache (/~user type requests)",
	"Mutate: 4 Enumerate user names via cgiwrap (/cgi-bin/cgiwrap/~user type requests)");
foreach opt (l)
{
 p = script_get_preference(opt);
 if ("yes" >< p) mutate = strcat(mutate, substr(opt, 8, 8));
}
if (strlen(mutate) > 0)
{
 argv[i++] = "-mutate";
 argv[i++] = mutate;
}

p = script_get_preference("Pause between tests (s)");
p = int(p);
if (p > 0)
{
 argv[i++] = "-Pause";
 argv[i++] = p;
}

p = script_get_preference("Root directory");
if (strlen(p) > 0)
{
 argv[i++] = "-root";
 argv[i++] = p;
}

p = script_get_preference("Single request monde");
if ("yes" >< p) argv[i++] = "-Single";

l = make_list("Tuning: 1 Interesting File / Seen in logs",
	"Tuning: 2 Misconfiguration / Default File",
	"Tuning: 3 Information Disclosure",
	"Tuning: 4 Injection (XSS/Script/HTML)",
	"Tuning: 5 Remote File Retrieval - Inside Web Root",
	"Tuning: 6 Denial of Service",
	"Tuning: 7 Remote File Retrieval - Server Wide",
	"Tuning: 8 Command Execution / Remote Shell",
	"Tuning: 9 SQL Injection",
	"Tuning: 0 File Upload",
	"Tuning: a Authentication Bypass",
	"Tuning: b Software Identification",
	"Tuning: c Remote Source Inclusion",
	"Tuning: x Reverse Tuning Options (i.e., include all except specified)");
tuning= '';
foreach opt (l)
{
 p = script_get_preference(opt);
 if ("yes" >< p) tuning = strcat(tuning, substr(opt, 8, 8));
}
if (strlen(tuning) > 0)
{
 argv[i++] = "-Tuning";
 argv[i++] = tuning;
}


p = get_preference("read_timeout");
p = int(p);
if (p > 0)
{
 argv[i++] = "-timeout";
 argv[i++] = p;
}

argv[i++] = "-host"; argv[i++] = get_host_ip();
argv[i++] = "-port"; argv[i++] = port;

encaps = get_port_transport(port);
if (encaps > 1) argv[i++] = "-ssl";

#p = script_get_preference("Force scan all possible CGI directories");
#if ("yes" >< p) argv[i++] = "-allcgi";
p = script_get_preference("Force full (generic) scan");
if ("yes" >< p) argv[i++] = "-generic";

if (idx && idx != "X")
{
  argv[i++] = "-evasion";
  argv[i++] = ids[0];
}

if (user)
{
  if (pass)
    s = strcat(user, ':', pass);
  else
    s = user;
  argv[i++] = "-id";
  argv[i++] = s;
}

r = pread(cmd: "nikto.pl", argv: argv, cd: 1);
if (! r) exit(0);	# error
if ("No HTTP(s) ports found" >< r) exit(0);

report = 'Here is the Nikto report:\n';
foreach l (split(r))
{
  #display(j ++, "\n");
  l = ereg_replace(string: l, pattern: '^[ \t]+', replace: '');
  if (l[0] == '+' || l[0] == '-' || ! match(pattern: "ERROR*", string: l))
    report += l;
}

security_note(port: port, data: report);
