#
# This script was written by David Lodge
#
# See the Nessus Scripts License for details
#
# Changes by rd:
# - recv() only receives the first two bytes of data (instead of 1024)
# - replaced ord(result[0]) == 0x1E by ord(result[0]) & 0x1E (binary AND)

 desc["english"] = "
Synopsis :

An NTP server is listening on the remote host.

Description :

An NTP (Network Time Protocol) server is listening on this port.
It provides information about the current date and time of the
remote system and may provide system information.

Risk factor :

None";


if(description)
{
 script_id(10884);
 script_version("$Revision: 1.14 $");
 name["english"] = "NTP read variables";
 script_name(english:name["english"]);
 

 script_description(english:desc["english"]);
 
 summary["english"] = "NTP allows query of variables";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 David Lodge");
 family["english"] = "General";
 script_family(english:family["english"]);

 exit(0);
}

#
# The script code starts here
#
#

function ntp_read_list()
{
    data = raw_string(0x16, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,0x00, 0x00, 0x00, 0x00);
    soc = open_sock_udp(123);
    if (!soc)exit(0);
    send(socket:soc, data:data);
    r = recv(socket:soc, length:4096);
    close(soc);

    if (! r) return(NULL);

    p = strstr(r, "version=");
    if (! p) p = strstr(r, "processor=");
    if (! p) p = strstr(r, "system=");
    p = ereg_replace(string:p, pattern:raw_string(0x22), replace:"'");

    if (p) return(p);
    return(NULL);
}


function ntp_installed()
{
data = raw_string(0xDB, 0x00, 0x04, 0xFA, 0x00, 0x01,
    		  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0xBE, 0x78, 0x2F, 0x1D, 0x19, 0xBA,
		  0x00, 0x00);

soc = open_sock_udp(123);
if (! soc ) exit(0);
send(socket:soc, data:data);
r = recv(socket:soc, length:4096);
close(soc);

if(strlen(r) > 10)
 {
 return(r);
 }
return(NULL);
}



# find out whether we can open the port

if( !(get_udp_port_state(123)) ) exit(0);



r = ntp_installed();
if(r)
   {
      set_kb_item(name:"NTP/Running", value:TRUE);
      list = ntp_read_list();
      if(!list)security_note(port:123, protocol:"udp");
      else
       {
       if ("system" >< list )
        {
         s = egrep(pattern:"system=", string:list);
	 os = ereg_replace(string:s, pattern:".*system='([^']*)'.*", replace:"\1");
         set_kb_item(name:"Host/OS/ntp", value:os);
        }
       if ("processor" >< list )
        {
         s = egrep(pattern:"processor=", string:list);
	 os = ereg_replace(string:s, pattern:".*processor='([^']*)'.*", replace:"\1");
         set_kb_item(name:"Host/processor/ntp", value:os);
        }

      report = string (
		desc["english"],
		"\n\nPlugin output :\n\n",
		"It was possible to gather the following information from the remote NTP host :\n\n",
		list
		);

      security_note(port:123, protocol:"udp", data:report);
    }
  }

 
