#
# written by K-Otik.com <ReYn0@k-otik.com>
#
# Nuked-klan Cross Site Scripting Bugs
#
#  Message-ID: <1642444765.20030319015935@olympos.org>
#  From: Ertan Kurt <mailto:ertank@olympos.org>
#  To: <bugtraq@securityfocus.com>
#  Subject: Some XSS vulns
#

if (description)
{
 script_id(11447);
 script_cve_id("CVE-2003-1238", "CVE-2003-1371");
 script_bugtraq_id(6916, 6917);
 script_version ("$Revision: 1.17 $");

 script_name(english:"Nuked-klan Cross-Site Scripting Bugs");
 desc["english"] = "
Synopsis :

The remote web server contains a PHP application that is prone to 
multiple issues.

Description :

Nuked-klan 1.3b fails to sanitize user-supplied input to several
parameters before using them in the 'Team', 'News', and 'Liens'
modules to display dynamic HTML.  An attacker may leverage these
issues to launch cross-site scripting attacks against the affected
host. 

In addition to this, another flaw may allow an attacker to obtain the
physical path of the directory in which the application is installed. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2003-03/0275.html
http://archives.neohapsis.com/archives/bugtraq/2003-02/0276.html

Solution : 

Contact the author for a patch.

Risk factor :

Medium / CVSS Base Score : 5.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:N)";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Nuked-klan is vulnerable to xss attack");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses : XSS");
 script_copyright(english:"This script is Copyright (C) 2003 k-otik.com");
 script_dependencie("http_version.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(get_kb_item(string("www/", port, "/generic_xss"))) exit(0);
if(!can_host_php(port:port))exit(0);

foreach d (cgi_dirs())
{
 url = string(d, "/index.php?file=Liens&op=", raw_string(0x22), "><script>window.alert('test');</script>");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL ) exit(0);

 if(ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 .*", string:buf) &&
    "<script>window.alert('test');</script>" >< buf)
   {
    security_warning(port);
    exit(0);
   }
}

