#
#  (C) Tenable Network Security
#

  desc = "
Synopsis :

The remote Windows host contains an office suite. 

Description :

Microsoft Office is installed on the remote host. 

See also :

http://office.microsoft.com

Risk factor : 

None";



if (description) 
{
 script_id(27524);
 script_version("$Revision: 1.5 $");

 script_name(english:"Microsoft Office Detection");
 script_summary(english:"Detects Microsoft Office");
 
 
 script_description(english:desc);
 
 script_category(ACT_GATHER_INFO);
 script_family(english:"Windows");

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 script_dependencies("smb_nt_ms02-031.nasl");
 if ( NASL_LEVEL >= 3206 ) script_require_ports("SMB/Office/Word/Version", "SMB/Office/Excel/Version", "SMB/Office/PowerPoint/Version");
 exit(0);
}



# version, sp, file version

i = 0;

# 2000 SP0
office_versions[i++] = make_list("Word", "2000", 0, "9.0.0.0");
office_versions[i++] = make_list("Excel", "2000", 0, "9.0.0.0");
office_versions[i++] = make_list("PowerPoint", "2000", 0, "9.0.0.0");

# 2000 SP1 - no information

# 2000 SP2
office_versions[i++] = make_list("Word", "2000", 2, "9.0.0.4527");
office_versions[i++] = make_list("Excel", "2000", 2, "9.0.0.4430");
office_versions[i++] = make_list("PowerPoint", "2000", 2, "9.0.0.4527");

# 2000 SP3
office_versions[i++] = make_list("Word", "2000", 3, "9.0.0.6926");
office_versions[i++] = make_list("Excel", "2000", 3, "9.0.0.6627");
office_versions[i++] = make_list("PowerPoint", "2000", 3, "9.0.0.6620");

# XP SP0
office_versions[i++] = make_list("Word", "XP", 0, "10.0.0.0");
office_versions[i++] = make_list("Excel", "XP", 0, "10.0.0.0");
office_versions[i++] = make_list("PowerPoint", "XP", 0, "10.0.0.0");

# XP SP1
office_versions[i++] = make_list("Word", "XP", 1, "10.0.3416.0");
office_versions[i++] = make_list("Excel", "XP", 1, "10.0.3506.0");
office_versions[i++] = make_list("PowerPoint", "XP", 1, "10.0.3506.0");

# XP SP2
office_versions[i++] = make_list("Word", "XP", 2, "10.0.4219.0");
office_versions[i++] = make_list("Excel", "XP", 2, "10.0.4302.0");
office_versions[i++] = make_list("PowerPoint", "XP", 2, "10.0.4205.0");

# XP SP3
office_versions[i++] = make_list("Word", "XP", 3, "10.0.6612.0");
office_versions[i++] = make_list("Excel", "XP", 3, "10.0.6501.0");
office_versions[i++] = make_list("PowerPoint", "XP", 3, "10.0.6501.0");

# 2003 SP0
office_versions[i++] = make_list("Word", "2003", 0, "11.0.0.0");
office_versions[i++] = make_list("Excel", "2003", 0, "11.0.0.0");
office_versions[i++] = make_list("PowerPoint", "2003", 0, "11.0.0.0");

# 2003 SP1
office_versions[i++] = make_list("Word", "2003", 1, "11.0.6359.0");
office_versions[i++] = make_list("Excel", "2003", 1, "11.0.6355.0");
office_versions[i++] = make_list("PowerPoint", "2003", 1, "11.0.6361.0");

# 2003 SP2
office_versions[i++] = make_list("Word", "2003", 2, "11.0.6568.0");
office_versions[i++] = make_list("Excel", "2003", 2, "11.0.6560.0");
office_versions[i++] = make_list("PowerPoint", "2003", 2, "11.0.6564.0");

# 2003 SP3
office_versions[i++] = make_list("Word", "2003", 3, "11.0.8169.0");
office_versions[i++] = make_list("Excel", "2003", 3, "11.0.8169.0");
office_versions[i++] = make_list("PowerPoint", "2003", 3, "11.0.8169.0");

# 2007 SP0
office_versions[i++] = make_list("Word", "2007", 0, "12.0.0.0");
office_versions[i++] = make_list("Excel", "2007", 0, "12.0.0.0");
office_versions[i++] = make_list("PowerPoint", "2007", 0, "12.0.0.0");



function check_version(v1, v2)
{
 local_var j;

 v1 = split(v1, sep:".", keep:FALSE);
 v2 = split(v2, sep:".", keep:FALSE);

 for (j=0; j<4; j++)
 {
  if (int(v1[j]) > int(v2[j]))
    return 1;
  else if (int(v1[j]) < int(v2[j]))
    return -1;
 }

 return 0;
}

version = report = NULL;

products = make_list("Word", "Excel", "PowerPoint");
foreach product (products)
{
 kb = get_kb_item(string("SMB/Office/", product, "/Version"));
 if (!isnull(kb))
 {
  report += string ("- ", product, ": ", kb, "\n");
  if (!version)
  {
   len = max_index(office_versions);
   for (i=0; i<len; i++)
   {
    info = office_versions[i];
    if (check_version(v1:kb, v2:info[3]) >= 0)
      version = i;
   }
  }
 }
}


if (report)
{
 if (version)
 {
  info = office_versions[version];
  report = string (
		desc,
		"\n\n",
		"Plugin output :\n",
		"\n",
		"The remote host is running Microsoft Office ", info[1],
		" Service Pack ", info[2], ".\n\n",
		"The following files have been found:\n",
		report);

  set_kb_item(name:"SMB/Office/Version", value:info[1]);
  set_kb_item(name:"SMB/Office/SP", value:info[2]);
 }
 else
   report = string (
		desc,
		"\n\n",
		"Plugin output :\n",
		"\n",
		"The following files have been found:\n", report);

 security_note(port:0, data:report);
}
