#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by
multiple issues. 

Description :

The remote host contains the Office Viewer Component, an ActiveX
control for working with Microsoft Office documents. 

The version of this control installed on the remote host contains a
buffer overflow in its 'HttpDownloadFile' method that could be
exploited to execute arbitrary code remotely if an attacker can trick
a user on the affected host into visiting a specially-crafted web
page. 

In addition, it also allows an attacker to delete arbitrary files via
the 'DeleteLocalFile' method. 

See also :

http://moaxb.blogspot.com/2007/05/moaxb-28-edraw-office-viewer-component.html
http://moaxb.blogspot.com/2007/05/moaxb-29-edraw-office-viewer-component.html
http://www.milw0rm.com/exploits/4009
http://www.milw0rm.com/exploits/4010
http://www.ocxt.com/archives/28

Solution :

Upgrade to Office Viewer Component version 5 or later.

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(26012);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-3168", "CVE-2007-3169");
  script_bugtraq_id(24229, 24230);
  script_xref(name:"OSVDB", value:"36044");
  script_xref(name:"OSVDB", value:"36045");

  script_name(english:"Office Viewer Component < 5.0 Multiple Vulnerabilities");
  script_summary(english:"Checks version of Office Viewer Component ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{053AFEBA-D968-435F-B557-19FF76372B1B}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"5.0.0.0") == TRUE)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Version ", ver, " of the vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n"
    );
    security_hole(port:kb_smb_transport(), data:report);
  }
}
activex_end();
