#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control with an insecure
method. 

Description :

The remote host contains the Office Viewer Component, an ActiveX
control for working with Microsoft Office documents. 

The version of this control installed on the remote host reportedly
contains an insecure method, 'HttpDownloadFile'.  If an attacker can
trick a user on the affected host into visiting a specially-crafted
web page, he may be able to use this method to place arbitrary files
on the host subject to the user's privileges. 

See also :

http://milw0rm.com/exploits/4290
http://www.ocxt.com/archives/39

Solution :

Upgrade to Office Viewer Component version 5.2 or later.

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(26013);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-4420");
  script_bugtraq_id(25344);
  script_xref(name:"OSVDB", value:"38794");

  script_name(english:"Office Viewer Component Insecure HttpDownloadFile Method Vulnerability");
  script_summary(english:"Checks version of Office Viewer Component ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{6BA21C22-53A5-463F-BBE8-5CF7FFA0132B}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"5.2.219.1") == TRUE)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Version ", ver, " of the vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n"
    );
    security_hole(port:kb_smb_transport(), data:report);
  }
}
activex_end();
